<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet href="sch_output.xsl" type="text/xsl" ?>
<iso:schema xmlns="http://purl.oclc.org/dsdl/schematron"
  xmlns:iso="http://purl.oclc.org/dsdl/schematron"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xmlns:cr="http://www.crossref.org/schema/4.3.0"
  queryBinding="xslt2"
  schemaVersion="ISO19757-3">


<iso:title>CrossRef schema v. 4.3.0</iso:title>
<iso:ns prefix="cr" uri="http://www.crossref.org/schema/4.3.0"/>
<!--<ns prefix="cr" uri="http://www.crossref.org/xschema/1.0"/>-->
<iso:ns prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance"/>

<iso:pattern name="Title Information">
  <iso:rule context="cr:journal_metadata">
    <iso:report test=".">TITLE: <iso:value-of select="cr:full_title"/> <iso:value-of select="cr:book_series_metadata/cr:titles/cr:title"/>, ISSN(s): <iso:value-of select="cr:issn"/></iso:report>
  </iso:rule>
</iso:pattern>

<!--page number check-->
<iso:pattern name="First Page Check">
  <iso:rule context="cr:pages/cr:first_page">
<iso:assert test="not(matches(.,'-'))" diagnostics="W3a">INFO: [3a]:'<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'</iso:assert>
</iso:rule>

  <iso:rule context="cr:pages/cr:first_page">
<iso:assert test="not(matches(.,'_'))" diagnostics="W2a">INFO: [2a]:'<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'</iso:assert>
</iso:rule>
 </iso:pattern>

<iso:pattern name="Last Page Check">
  <iso:rule context="cr:pages/cr:last_page">
<iso:assert test="not(matches(.,'-'))" diagnostics="W3b">INFO: [3b]:'<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'</iso:assert>
</iso:rule>
  <iso:rule context="cr:pages/cr:last_page">
<iso:assert test="not(matches(.,'_'))" diagnostics="W2b">INFO: [2b]:'<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'</iso:assert>
</iso:rule>
 </iso:pattern>
 
 
 <!--<iso:pattern name="Year Range">
  <iso:rule context="cr:journal_issue">
<iso:assert test="cr:year &lt;= 2010" diagnostics="W4">INFO: [4] year = <iso:value-of select="ancestor::cr:journal_issue/cr:publication_date/cr:year"/></iso:assert>
</iso:rule>
 </iso:pattern>
-->

<iso:pattern name="Edition Numbers">
  <iso:rule context="cr:edition_number">
  <iso:assert test="not(matches(.,'[Nn][Oo]'))" diagnostics="W5">INFO: [5] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
<iso:assert test="not(matches(.,'[Nn][Oo]\.'))" diagnostics="W5">INFO: [5] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
  <iso:assert test="not(matches(.,'[Ee][Dd]'))" diagnostics="W5">INFO: [5] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
<iso:assert test="not(matches(.,'[Ee][Dd]\.'))" diagnostics="W5">INFO: [5] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
<iso:assert test="not(matches(.,'[Ee][Dd][Ii][Tt][Ii][Oo][Nn]'))" diagnostics="W5">INFO: [5] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
<iso:assert test="not(matches(.,'[Nn][Uu][Mm][Bb][Ee][Rr]'))" diagnostics="W5">INFO: [5] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
</iso:rule>
 </iso:pattern>

<iso:pattern name="Contributor Check">

  <iso:rule context="*[upper-case(cr:surname)]">
<iso:assert test="true()" diagnostics="W9">INFO: [9]:DOI: '<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/> </iso:assert>
</iso:rule>
<iso:rule context="cr:contributors">
<iso:assert test="count(cr:person_name) >= 1" diagnostics="W10">INFO: [10]:'<value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'.</iso:assert>
</iso:rule>
<iso:rule context="cr:given_name">
    <iso:assert test="string-length(.) > 1" diagnostics="W11">INFO: [11]: DOI: '<value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'</iso:assert>
  </iso:rule>
 <iso:rule context="cr:surname">
    <iso:assert test="not(matches(., '[Jj][Rr]\.'))"  diagnostics="W12">INFO: [12] :DOI: '<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'</iso:assert>
  </iso:rule>
</iso:pattern>

<iso:pattern name="Issue Numbers">
  <iso:rule context="cr:journal_issue/cr:issue">
  <iso:assert test="not(matches(.,'[Nn][Oo]'))" diagnostics="W13">INFO: [13] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
<iso:assert test="not(matches(.,'[Nn][Oo]\.'))" diagnostics="W13">INFO: [13] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
<iso:assert test="not(matches(.,'[Ii][Ss][Ss][Uu][Ee]\.'))" diagnostics="W13">INFO: [13] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
<iso:assert test="not(matches(.,'[Ii][Ss][Ss][Uu][Ee]'))" diagnostics="W13">INFO: [13] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
<iso:assert test="not(matches(.,'[Nn][Uu][Mm][Bb][Ee][Rr]\.'))" diagnostics="W13">INFO: [13] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
<iso:assert test="not(matches(.,'[Nn][Uu][Mm][Bb][Ee][Rr]'))" diagnostics="W13">INFO: [13] issue value = <iso:value-of select="ancestor::cr:journal_issue/cr:issue"/></iso:assert>
</iso:rule>
 </iso:pattern>
 
<iso:pattern name="First Page Check">
  <iso:rule context="cr:journal_article/cr:titles">
<iso:report test="not(matches(.,' '))" diagnostics="W14">INFO: [14]:'<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'</iso:report>
</iso:rule>
</iso:pattern>
<!--Alert-->

<iso:pattern name="DOI Character check">
<iso:rule context="cr:doi">
<iso:assert test="translate(.,'./():0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz-1234567890','') = ''" diagnostics="A1">INFO: [A1]<iso:value-of select="."/></iso:assert>
</iso:rule>
</iso:pattern>

<iso:pattern name="Name Alerts">
<iso:rule context="cr:given_name">
    <iso:assert test="translate(.,'. ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz','') = ''" diagnostics="A2g">INFO: [A2]: DOI: '<value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'</iso:assert>
  </iso:rule>
 <iso:rule context="cr:surname">
    <iso:assert test="translate(.,'. ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz','') = ''" diagnostics="A2s">INFO: [A2] :DOI: '<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'</iso:assert>
  </iso:rule>
 </iso:pattern>

 <iso:diagnostics>
   <iso:diagnostic id="W2a">
         First Page for DOI: '<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>' contains '-'.  Deposit first page only.
      </iso:diagnostic>
        <iso:diagnostic id="W2b">
        Last Page for DOI: '<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>' contains '-'.  Deposit first page only.
      </iso:diagnostic>
  <iso:diagnostic id="W3a">
         First Page for DOI: '<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>' contains '_'.  Deposit first page only.
      </iso:diagnostic>
        <iso:diagnostic id="W3b">
        Last Page for DOI: '<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>' contains _'.  Deposit first page only.
      </iso:diagnostic>
<iso:diagnostic id="W4">
        Year value for issue '<iso:value-of select="ancestor::cr:journal/cr:journal_issue/cr:issue"/>' is <iso:value-of select="ancestor::cr:journal/cr:journal_issue/cr:publication_date/cr:year"/>
</iso:diagnostic>
<iso:diagnostic id="W5">
        Value for edition is '<iso:value-of select="ancestor::cr:journal_issue/cr:issue"/>'  - text 'edition' 'no' or 'number' should not appear in edition_number element. Deposit edition number only.
</iso:diagnostic>       


<iso:diagnostic id="W9">
          Deposited value of surname for DOI '<value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>' is all upper case: '<value-of select="."/>'. 
</iso:diagnostic>
      <iso:diagnostic id="W10">
          Only single contributor is present for DOI '<value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'. Deposit all authors.
      </iso:diagnostic>
         <iso:diagnostic id="W11">
          INFO: Deposited value of given_name for DOI '<value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>' is '<value-of select="."/>'. Deposit full names.</iso:diagnostic>
       <iso:diagnostic id="W12">
         Surname '<iso:value-of select="."/>' contains 'Jr.' DOI: '<iso:value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>'
         </iso:diagnostic>
<iso:diagnostic id="W13">
        Value for issue is '<iso:value-of select="ancestor::cr:journal_issue/cr:issue"/>'  - text 'issue' should not appear in issue element. Deposit issue number only.
</iso:diagnostic>         

<iso:diagnostic id="W14">
        Value for article title is '<iso:value-of select="ancestor::cr:journal_article/cr:titles/cr:title"/>' This is a single word title.
</iso:diagnostic>  
         
         <iso:diagnostic id="A1">
         DOI <iso:value-of select="."/> contains a character not in the allowed DOI character set.
         </iso:diagnostic>

   
<iso:diagnostic id="A2g">
          Deposited value of surname or given name for DOI '<value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>' is: '<value-of select="."/>'. Names with numbers or punctuation will be rejected.
</iso:diagnostic>
<iso:diagnostic id="A2s">
          Deposited value of surname or given name for DOI '<value-of select="ancestor::cr:journal_article/cr:doi_data/cr:doi"/>' is: '<value-of select="."/>'. Names with numbers or punctuation will be rejected.
</iso:diagnostic>
   </iso:diagnostics>

</iso:schema>
