/*
 * Decompiled with CFR 0.152.
 */
package org.crossref.tools.submissions;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class CrossrefSubmissionUploadTool {
    private static final SimpleDateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    private String usage = String.format("usage: %s \n", CrossrefSubmissionUploadTool.class.getCanonicalName());
    private String protocol = "https";
    private String host = "doi.crossref.org";
    private int port = 443;
    private String path = "/deposit/";
    private String userName;
    private String userPassword;
    private List<String[]> additionalParameters = new LinkedList<String[]>();
    private Map<String, List<File>> submissionsByType = new HashMap<String, List<File>>();
    private boolean dryRun = false;

    public static void main(String ... args) throws Exception {
        CrossrefSubmissionUploadTool tool = new CrossrefSubmissionUploadTool();
        for (int i = 0; i < args.length; ++i) {
            if ("--url".equals(args[i])) {
                URL url = new URL(args[i + 1]);
                tool.setProtocol(url.getProtocol());
                tool.setHost(url.getHost());
                tool.setPort(url.getPort());
                tool.setPath(url.getPath());
                ++i;
                continue;
            }
            if ("--user".equals(args[i])) {
                tool.setUser(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if ("--metadata".equals(args[i])) {
                for (File file : CrossrefSubmissionUploadTool.listFiles(new File(args[i + 1]))) {
                    tool.addMetadata(file);
                }
                ++i;
                continue;
            }
            if ("--resources".equals(args[i])) {
                for (File file : CrossrefSubmissionUploadTool.listFiles(new File(args[i + 1]))) {
                    tool.addResource(file);
                }
                ++i;
                continue;
            }
            if ("--transfers".equals(args[i])) {
                for (File file : CrossrefSubmissionUploadTool.listFiles(new File(args[i + 1]))) {
                    tool.addTransfer(file);
                }
                ++i;
                continue;
            }
            if ("--handles".equals(args[i])) {
                for (File file : CrossrefSubmissionUploadTool.listFiles(new File(args[i + 1]))) {
                    tool.addHandle(file);
                }
                ++i;
                continue;
            }
            if ("--conflicts".equals(args[i])) {
                for (File file : CrossrefSubmissionUploadTool.listFiles(new File(args[i + 1]))) {
                    tool.addConflict(file);
                }
                ++i;
                continue;
            }
            if ("--query".equals(args[i]) || "--queries".equals(args[i])) {
                for (File file : CrossrefSubmissionUploadTool.listFiles(new File(args[i + 1]))) {
                    tool.addQuery(file);
                }
                ++i;
                continue;
            }
            if ("--host".equals(args[i])) {
                tool.setHost(args[i + 1]);
                ++i;
                continue;
            }
            if ("--dry-run".equals(args[i])) {
                tool.setDryRun(true);
                continue;
            }
            if ("--version".equals(args[i])) {
                System.out.printf("%s 1.1.0\n", CrossrefSubmissionUploadTool.class.getCanonicalName());
                System.exit(0);
                continue;
            }
            if ("--usage".equals(args[i])) {
                tool.setUsage(args[i + 1]);
                ++i;
                continue;
            }
            if ("--p".equals(args[i])) {
                tool.addAdditionalParameter(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (!args[i].startsWith("-")) continue;
            if (!"--help".equals(args[i])) {
                System.out.printf("error: unknown command line argument \"%s\"\n", args[i]);
            }
            System.out.printf("%s  --user name password \n  --metadata ( file | directory ) \n  --conflicts ( file | directory ) \n  --transfers ( file | directory ) \n  --resources ( file | directory ) \n  --handles ( file | directory ) \n  --query ( file | directory ) \n  --host host \n  --url deposit-url \n  --dry-run \n  --help\n", tool.usage);
            System.exit(1);
        }
        tool.execute();
    }

    public void addAdditionalParameter(String name, String value) {
        this.additionalParameters.add(new String[]{name, value});
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUser(String userName, String userPassword) {
        this.userName = userName;
        this.userPassword = userPassword;
    }

    public void addSubmisson(String type, File file) {
        List<File> files = this.submissionsByType.get(type);
        if (files == null) {
            files = new ArrayList<File>();
            this.submissionsByType.put(type, files);
        }
        files.add(file);
    }

    public void addMetadata(File file) {
        this.addSubmisson("doMDUpload", file);
    }

    public void addResource(File file) {
        this.addSubmisson("doDOICitUpload", file);
    }

    public void addTransfer(File file) {
        this.addSubmisson("doTransferDOIsUpload", file);
    }

    public void addHandle(File file) {
        this.addSubmisson("doHandleSynchUpload", file);
    }

    public void addConflict(File file) {
        this.addSubmisson("doMDUpload", file);
    }

    public void addQuery(File file) {
        this.addSubmisson("doQueryUpload", file);
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute() throws Exception {
        if (this.dryRun) {
            this.log(Level.INFO, "making a dry run", new Object[0]);
        }
        if (this.userName == null || this.userPassword == null) {
            this.log(Level.ERROR, "user name and password must be given", new Object[0]);
            return;
        }
        this.log(Level.INFO, "uploading to {0}://{1}:{2,number,####}{3}", new Object[]{this.protocol, this.host, this.port, this.path});
        client = new HttpClient();
        url = new SimpleUrlBuilder().setProtocol(this.protocol).setHost(this.host).setPort(this.port).setPath(this.path).build();
        for (String type : this.submissionsByType.keySet()) lbl-1000:
        // 9 sources

        {
            block9: for (File file : this.submissionsByType.get(type)) {
                this.log(Level.INFO, "uploading submission: file={0} ({1})", new Object[]{file, type});
                if (this.dryRun) continue;
                parts = new Part[4 + this.additionalParameters.size()];
                parts[0] = new StringPart("operation", type, "UTF-8");
                parts[1] = new StringPart("usr", this.userName, "UTF-8");
                parts[2] = new StringPart("pwd", this.userPassword, "UTF-8");
                parts[3] = new FilePart("mdFile", file, "text/xml", "UTF-8");
                l = parts.length;
                for (i = 4; i < l; ++i) {
                    additionalParameter = this.additionalParameters.get(i - 4);
                    parts[i] = new StringPart(additionalParameter[0], additionalParameter[1], "UTF-8");
                }
                method = new PostMethod(url);
                try {
                    method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
                    statusCode = client.executeMethod((HttpMethod)method);
                    switch (statusCode) {
                        case 200: {
                            this.log(Level.INFO, "uploaded submission: file={0}", new Object[]{file});
                            result = method.getResponseBodyAsString();
                            if (result == null || result.trim().length() <= 0) continue block9;
                            System.out.print(result);
                            ** break;
                        }
                        case 403: {
                            this.log(Level.INFO, "unsuccessful submission: file={0}; user={1}", new Object[]{file, this.userName});
                            result = method.getResponseBodyAsString();
                            if (result == null || result.trim().length() <= 0) continue block9;
                            System.out.print(result);
                            ** break;
                        }
                        case 401: {
                            this.log(Level.INFO, "unauthorized: file={0}; user={1}", new Object[]{file, this.userName});
                            ** break;
                        }
                        default: {
                            this.log(Level.INFO, "unable to upload submission: status={0}; file={1}", new Object[]{statusCode, file});
                            continue block9;
                        }
                    }
                }
                finally {
                    method.releaseConnection();
                }
            }
        }
        this.log(Level.INFO, "done", new Object[0]);
    }

    private static List<File> listFiles(File element) {
        LinkedList<File> files = new LinkedList<File>();
        if (element.isDirectory()) {
            for (File f : element.listFiles()) {
                if (!f.isFile()) continue;
                files.add(f);
            }
        } else {
            files.add(element);
        }
        return files;
    }

    private void log(Level level, Throwable throwable, String message, Object ... parameters) {
        this.log(level, message, parameters);
        throwable.printStackTrace(System.out);
    }

    private void log(Level level, String message, Object ... parameters) {
        System.out.print(LOG_DATE_FORMAT.format(new Date()));
        System.out.print(" ");
        System.out.print(level.name());
        System.out.print(" ");
        System.out.println(MessageFormat.format(message, parameters));
    }

    static class SimpleUrlBuilder {
        private static final Map<String, Integer> PROTOCOL_TO_DEFAULT_PORT = new HashMap<String, Integer>();
        private String protocol = "http";
        private String host = "localhost";
        private int port = 80;
        private File path;
        private Map<String, List<String>> query = new TreeMap<String, List<String>>();
        private String reference;

        private SimpleUrlBuilder() {
        }

        public SimpleUrlBuilder(String seedUrl) throws IllegalStateException {
            try {
                URL url = new URL(seedUrl);
                this.protocol = url.getProtocol();
                this.host = url.getHost();
                this.port = url.getPort();
                this.path = new File(url.getPath());
                this.query = SimpleUrlBuilder.parseQuery(url.getQuery(), new HashMap<String, List<String>>());
                this.reference = url.getRef();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("unable to parse url " + seedUrl, e);
            }
        }

        public SimpleUrlBuilder copy() {
            SimpleUrlBuilder b = new SimpleUrlBuilder();
            b.setProtocol(this.protocol);
            b.setHost(this.host);
            b.setPort(this.port);
            b.setPath(this.path.getAbsolutePath());
            b.setQuery(this.query);
            b.setReference(this.reference);
            return b;
        }

        public SimpleUrlBuilder setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public SimpleUrlBuilder setHost(String host) {
            this.host = host;
            return this;
        }

        public SimpleUrlBuilder setPort(int port) {
            this.port = port;
            return this;
        }

        public SimpleUrlBuilder setPath(String path) {
            this.path = new File(path);
            return this;
        }

        public SimpleUrlBuilder setQuery(Map<String, List<String>> query) {
            this.query = new HashMap<String, List<String>>(query);
            return this;
        }

        public SimpleUrlBuilder setReference(String reference) {
            this.reference = reference;
            return this;
        }

        public SimpleUrlBuilder addParameter(String name, Object value) {
            List<String> values = this.query.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.query.put(name, values);
            }
            values.add(value.toString());
            return this;
        }

        public SimpleUrlBuilder setParameter(String name, Object value) {
            List<String> values = this.query.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.query.put(name, values);
            } else {
                values.clear();
            }
            values.add(value.toString());
            return this;
        }

        public List<String> findParameter(String name) {
            List<String> values = this.query.get(name);
            if (values == null) {
                values = Collections.emptyList();
            }
            return values;
        }

        public SimpleUrlBuilder addPath(Object ... parts) {
            for (Object part : parts) {
                this.path = new File(this.path, part.toString());
            }
            return this;
        }

        public String build() {
            StringBuilder u = new StringBuilder();
            u.append(this.protocol);
            u.append("://");
            u.append(this.host);
            if (!(this.port == -1 || PROTOCOL_TO_DEFAULT_PORT.containsKey(this.protocol) && PROTOCOL_TO_DEFAULT_PORT.get(this.protocol) == this.port)) {
                u.append(":").append(this.port);
            }
            u.append(this.path == null ? "/" : this.path.getAbsolutePath());
            if (!this.query.isEmpty()) {
                u.append("?");
                boolean notFirstParmater = false;
                for (Map.Entry<String, List<String>> e : this.query.entrySet()) {
                    String name = SimpleUrlBuilder.encode(e.getKey());
                    for (String v : e.getValue()) {
                        if (notFirstParmater) {
                            u.append("&");
                        }
                        u.append(name).append("=").append(SimpleUrlBuilder.encode(v.toString()));
                        notFirstParmater = true;
                    }
                }
            }
            if (this.reference != null) {
                u.append("#").append(this.reference);
            }
            return u.toString();
        }

        public static Map<String, List<String>> parseQuery(String query, Map<String, List<String>> parameters) {
            if (query != null) {
                StringTokenizer pairs = new StringTokenizer(query, "&");
                while (pairs.hasMoreTokens()) {
                    String pair = pairs.nextToken();
                    StringTokenizer parts = new StringTokenizer(pair, "=");
                    String name = SimpleUrlBuilder.decode(parts.nextToken());
                    String value = parts.hasMoreTokens() ? SimpleUrlBuilder.decode(parts.nextToken()) : "";
                    List<String> values = parameters.get(name);
                    if (values == null) {
                        values = new LinkedList<String>();
                        parameters.put(name, values);
                    }
                    values.add(value);
                }
            }
            return parameters;
        }

        public static String decode(String input) {
            try {
                return URLDecoder.decode(input, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String encode(String input) {
            try {
                return URLEncoder.encode(input, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        static {
            PROTOCOL_TO_DEFAULT_PORT.put("http", 80);
            PROTOCOL_TO_DEFAULT_PORT.put("https", 443);
            PROTOCOL_TO_DEFAULT_PORT.put("ftp", 20);
        }
    }

    private static enum Level {
        INFO,
        WARNING,
        ERROR;

    }
}

